﻿using System;
using System.Collections.Generic;
using System.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class FragLabInterpretationFragment : BasePage
{
    private readonly LabResultsManager _manager;
    private FRAGMENT_ANALYSI _fragment;

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/FragLabResult.aspx",
        "/FragLabInterpretation.aspx",
        "/PatientWorkflows.aspx"
    };

    public FragLabInterpretationFragment()
    {
        _manager = new LabResultsManager();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int fragmentId;

            if (int.TryParse(Request.QueryString["fragmentId"], out fragmentId))
            {
                getRefreshFragment(fragmentId);
                SetupFragment();

                BreadCrumbLabel.Text = $"My Tasks > Interpretation & Follow Up > {_fragment.WKF_CASE_ACTIVITY.STD_WKFACTIVITYST.NAME} > Workflow ID > {_fragment.WKF_CASE_ACTIVITY.WKF_CASE_ID} > Fragments > Fragment ID > {fragmentId}";
            }

            SetReferringPage();
        }
    }

    private void SetupFragment()
    {
        lblFragmentId.Text = _fragment.FRAGMENT_ID_NUMBER;
        lblFragDesc.Text = _fragment.FRAGMENT_DESCR;
        lblFragMass.Text = _fragment.FRAGMENT_MASS_MEASURE;
        lblMassmsrmts.Text = _fragment.MASS_UNITS;
        lblLength.Text = string.IsNullOrEmpty(_fragment.FRAGMENT_LENGTH_MEASURE) ? string.Empty : _fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[0];

        if (!string.IsNullOrEmpty(_fragment.FRAGMENT_LENGTH_MEASURE))
        {
            if (_fragment.FRAGMENT_LENGTH_MEASURE.Split(' ').Length > 1)
            {
                lblLengthmsrmts.Text = _fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[1];
            }

            lblHeight.Text = string.IsNullOrEmpty(_fragment.FRAGMENT_HEIGHT_MEASURE) ? string.Empty : _fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[0];
        }

        if (!string.IsNullOrEmpty(_fragment.FRAGMENT_HEIGHT_MEASURE))
        {
            if (_fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ').Length > 1)
                lblHeightmsrmts.Text = _fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[1];

        }

        if (!string.IsNullOrEmpty(_fragment.FRAGMENT_WIDTH_MEASURE))
        {
            lblWidth.Text = string.IsNullOrEmpty(_fragment.FRAGMENT_WIDTH_MEASURE) ? string.Empty : _fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[0]; ;
            if (_fragment.FRAGMENT_WIDTH_MEASURE.Split(' ').Length > 1)
                lblWidthmsrmts.Text = _fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[1];
        }

        lblRadioactive.Text = _fragment.FRAGMENT_RADIOACTIVE_TEST_IND.HasValue ? _fragment.FRAGMENT_RADIOACTIVE_TEST_IND.Value == 'Y' ? "Yes" : "No" : "Not Tested";
        lblRadActiveTestResult.Text = _fragment.FRAGMENT_RADIOACTIVE_RESULT;
        lblComments.Text = _fragment.COMMENT_TEXT;
        lblTissueSent.Text = _fragment.TISSUE_SENT_FLAG ? "Yes" : "No";
        lblTissueResults.Text = _fragment.TISSUE_RESULT_TEXT;

        BindGridView();
    }


    private void getRefreshFragment(int fragId)
    {
        _fragment = _manager.getFragByFragmentID(fragId);
    }

    private void BindGridView()
    {

        if (_fragment != null && _fragment.ANALYSIS_DETAILs.Count() > 0)
            GridViewAnalyteData.DataSource = _fragment.ANALYSIS_DETAILs;
        else
            GridViewAnalyteData.DataSource = new List<ANALYSIS_DETAIL>();

        GridViewAnalyteData.DataBind();
    }

    protected void CancelButton_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabResults";
    }

    public override string AppObjectCode()
    {
        return "LabResults";
    }


}
